#pragma rtGlobals=1		// Use modern global access method.

Macro MacroGraph(type,p1,p2)
	String type
	String p1="e1"
	string p2="e2"
	Prompt type,"Graph Type", popup, "Momenta;Angle&Energy;Correlation"
	Prompt p1,"1rst particle label"
	Prompt p2,"2nd particle label (option)"
	
	if (!cmpstr(type,"Momenta"))
				Graph_Momenta(p1)
	endif
	if (!cmpstr(type,"Angle&Energy"))
				Graph_AngleEnergy(p1)
	endif
	if (!cmpstr(type,"Correlation"))
				Graph_Correlation(p1,p2)
	endif
end

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												GRAPH MOMENTA - ANGLE - ENERGY
//-------------------------------------------------------------------------------------------------------------------------------------------------------------   

Proc Graph_Momenta(particle) 
	String particle
	Silent 1; DelayUpdate;	
	Display /W=(14,45,364,322)/L=Left_top/B=Bottom_top $("Hist_px_"+particle) as "Momenta Imaging: "+particle
	AppendToGraph/L=Left_top/B=py_top $("Hist_py_"+particle)
	AppendToGraph/L=Left_top/B=pz_top $("Hist_pz_"+particle)
	AppendImage $("px_"+particle+"_py_"+particle)
	ModifyImage $("px_"+particle+"_py_"+particle) ctab= {*,*,Rainbow,1}
	AppendImage/B=pzpx $("pz_"+particle+"_px_"+particle)
	ModifyImage $("pz_"+particle+"_px_"+particle) ctab= {*,*,Rainbow,1}
	AppendImage/B=pzpy $("pz_"+particle+"_py_"+particle)
	ModifyImage $("pz_"+particle+"_py_"+particle) ctab= {*,*,Rainbow,1}
	ModifyGraph width={Aspect,1.5}
	ModifyGraph rgb=(0,0,0)
	ModifyGraph mirror(left)=0,mirror(bottom)=0
	ModifyGraph standoff(left)=0,standoff(bottom)=0
	ModifyGraph lblPos(Bottom_top)=30,lblPos(py_top)=30,lblPos(pz_top)=30,lblPos(left)=37
	ModifyGraph lblPos(bottom)=37,lblPos(pzpx)=37,lblPos(pzpy)=37
	ModifyGraph lblLatPos(left)=-1
	ModifyGraph freePos(Left_top)=0
	ModifyGraph freePos(Bottom_top)={0,Left_top}
	ModifyGraph freePos(py_top)={0,Left_top}
	ModifyGraph freePos(pz_top)={0,Left_top}
	ModifyGraph freePos(pzpx)=0
	ModifyGraph freePos(pzpy)=0
	ModifyGraph axisEnab(Left_top)={0.65,1}
	ModifyGraph axisEnab(Bottom_top)={0,0.28}
	ModifyGraph axisEnab(py_top)={0.36,0.64}
	ModifyGraph axisEnab(pz_top)={0.72,1}
	ModifyGraph axisEnab(left)={0,0.45}
	ModifyGraph axisEnab(bottom)={0,0.28}
	ModifyGraph axisEnab(pzpx)={0.36,0.64}
	ModifyGraph axisEnab(pzpy)={0.72,1}
	Label Bottom_top "\\f01Px"
	Label py_top "\\f01Py"
	Label pz_top "\\f01Pz"
	Label left "\\f01Py"
	Label bottom "\\f01Px"
	Label pzpx "\\f01Pz"
	Label pzpy "\\f01Pz"
	SetAxis/A/N=1/E=1 Left_top
	TextBox/N=text0/O=90/F=0/A=MC/X=-17.75/Y=-27.17 "\\f01Px"
	TextBox/N=text0_1/O=90/F=0/A=MC/X=18.48/Y=-27.72 "\\f01Py"
	ControlBar 45
	SetVariable Scale,pos={23,5},size={130,15},title="Momenta Scale",value= K0
	Button $("Refresh_"+particle),pos={166,13},size={60,20},proc=RefreshMomenta,title="Refresh"
	SetVariable Bining,pos={241,16},size={91,15},title="Bining",value= K2
	SetVariable Threshold,pos={23,26},size={130,15},title="Momenta Slice",value= K1
EndMacro

Proc Graph_AngleEnergy(particle)
	String particle
	Silent 1; DelayUpdate;
	Display /W=(370,44,683,497)/R=Y_mid1D/B=X_mid1D $("Hist_dvthet_"+particle) as "Angles & Energy: "+particle
	AppendToGraph/R/B=bottom1D $("Hist_E_"+particle)
	AppendToGraph/R=Y_top1D/B=X_top1D $("Hist_thet_"+particle),$("Hist_phi_"+particle)
	AppendToGraph/R=Y_mid1D/B=X_mid1D $("Hist_dvphi_"+particle)
	AppendToGraph/R=Y_down1D/B=bottom1D $("Hist_Elong_"+particle),$("Hist_Etrans_"+particle)
	AppendImage $("Elong_"+particle+"_Etrans_"+particle)
	ModifyImage $("Elong_"+particle+"_Etrans_"+particle) ctab= {*,*,Rainbow,1}
	AppendImage/B=X_mid2D/L=Y_mid2D $("dvthet_"+particle+"_dvphi_"+particle)
	ModifyImage $("dvthet_"+particle+"_dvphi_"+particle) ctab= {*,*,Rainbow,1}
	AppendImage/B=X_top2D/L=Y_top2D $("thet_"+particle+"_phi_"+particle)
	ModifyImage $("thet_"+particle+"_phi_"+particle) ctab= {*,*,Rainbow,1}
	ModifyGraph height={Aspect,1.7}
	ModifyGraph lStyle($("Hist_phi_"+particle))=2,lStyle($("Hist_dvphi_"+particle))=2
	ModifyGraph rgb($("Hist_dvthet_"+particle))=(1,4,52428),rgb($("Hist_E_"+particle))=(0,0,0),rgb($("Hist_thet_"+particle))=(0,0,65535)
	ModifyGraph rgb($("Hist_Etrans_"+particle))=(1,4,52428)
	ModifyGraph tick(Y_down1D)=2
	ModifyGraph mirror(right)=0,mirror(left)=0,mirror(bottom)=0
	ModifyGraph noLabel(Y_down1D)=2
	ModifyGraph axThick(Y_down1D)=0
	ModifyGraph lblPos(right)=62,lblPos(bottom1D)=37,lblPos(left)=48,lblPos(bottom)=37
	ModifyGraph lblPos(Y_mid2D)=37,lblPos(X_mid2D)=30,lblPos(Y_top2D)=37,lblPos(X_top2D)=30
	ModifyGraph freePos(Y_mid1D)=0
	ModifyGraph freePos(X_mid1D)={0,Y_mid1D}
	ModifyGraph freePos(bottom1D)={0,left}
	ModifyGraph freePos(Y_top1D)=0
	ModifyGraph freePos(X_top1D)={0,Y_top1D}
	ModifyGraph freePos(Y_down1D)={0,bottom1D}
	ModifyGraph freePos(Y_mid2D)=0
	ModifyGraph freePos(X_mid2D)={-3.31,Y_mid2D}
	ModifyGraph freePos(Y_top2D)=0
	ModifyGraph freePos(X_top2D)={-3.3,Y_top2D}
	ModifyGraph axisEnab(Y_mid1D)={0.36,0.64}
	ModifyGraph axisEnab(X_mid1D)={0.55,1}
	ModifyGraph axisEnab(right)={0,0.28}
	ModifyGraph axisEnab(bottom1D)={0.55,1}
	ModifyGraph axisEnab(Y_top1D)={0.72,1}
	ModifyGraph axisEnab(X_top1D)={0.55,1}
	ModifyGraph axisEnab(Y_down1D)={0.01,0.28}
	ModifyGraph axisEnab(left)={0,0.28}
	ModifyGraph axisEnab(bottom)={0,0.45}
	ModifyGraph axisEnab(Y_mid2D)={0.36,0.64}
	ModifyGraph axisEnab(X_mid2D)={0,0.45}
	ModifyGraph axisEnab(Y_top2D)={0.72,1}
	ModifyGraph axisEnab(X_top2D)={0,0.45}
	Label bottom1D "E(eV)"
	Label left "E\\Btransverse"
	Label bottom "E\\Blongitudinal"
	Label Y_mid2D "\\F'Symbol'j"
	Label X_mid2D "\\F'Symbol'q"
	Label Y_top2D "\\F'Symbol'j"
	Label X_top2D "\\F'Symbol'q"
	SetAxis/A/N=1/E=1 Y_mid1D
	SetAxis/A/N=1/E=1 right
	SetAxis/A/E=1 bottom1D
	SetAxis/A/N=1/E=1 Y_top1D
	SetAxis/A/E=1 Y_down1D
	TextBox/N=text0/F=0/B=1/A=MC/X=27.36/Y=49.44 "\\F'Symbol'\\s(Hist_thet_"+particle+")q \\s(Hist_phi_"+particle+")j"
	TextBox/N=text0_1/F=0/B=1/A=MC/X=27.36/Y=12.78 " \\F'Symbol'\\s(Hist_dvthet_"+particle+")q \\s(Hist_dvphi_"+particle+")j"
	TextBox/N=text0_2/F=0/B=1/A=MC/X=27.36/Y=-24.17 "\\Z12\\s(Hist_etrans_"+particle+")E\\Btrans\\M \\Z12\\s(Hist_elong_"+particle+")E\\Blong"
	AppendText "\t     \\M \\Z12\\s(Hist_e_"+particle+")E"
	TextBox/N=text1/S=3/B=1/A=MC/X=1.89/Y=13.33 "Lab"
	TextBox/N=text1_1/S=3/B=1/A=MC/X=3.30/Y=49.72 "Light "
	ControlBar 45
	SetVariable Emin,pos={8,5},size={110,15},title="Energy min",value= K3
	SetVariable Emax,pos={8,27},size={110,15},title="Energy max",value= K4
	Button $("Refresh_"+particle),pos={139,12},size={60,20},proc=RefreshAngleAnergy,title="Refresh"
	SetVariable Bin,pos={215,15},size={91,15},title="Bining",value= K5
EndMacro

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												GRAPH CORRELATION
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  

Proc Graph_Correlation(particle1, particle2)
	String particle1, particle2
	Silent 1; DelayUpdate;
	Display /W=(437,136,821,726)/R/B=bottom1D $("Hist_etot_"+particle1+particle2),$("Hist_E_"+particle1),$("Hist_E_"+particle2) as "Correlations:"+particle1+" vs "+particle2
	AppendToGraph/R=Y_mid1D/B=X_mid1D $("Hist_phi_"+particle1),$("Hist_phi_"+particle2)
	AppendToGraph/R=Y_top1D/B=X_top1D $("Hist_thet_"+particle1),$("Hist_thet_"+particle2)
	AppendImage $("E_"+particle2+"_E_"+particle1)
	ModifyImage $("E_"+particle2+"_E_"+particle1) ctab= {*,*,Rainbow,1}
	AppendImage/B=X_mid2D/L=Y_mid2D $("phi_"+particle1+"_phi_"+particle2)
	ModifyImage $("phi_"+particle1+"_phi_"+particle2) ctab= {*,*,Rainbow,1}
	AppendImage/B=X_top2D/L=Y_top2D $("thet_"+particle1+"_thet_"+particle2)
	ModifyImage $("thet_"+particle1+"_thet_"+particle2) ctab= {*,*,Rainbow,1}
	ModifyGraph height={Aspect,1.7}
	ModifyGraph rgb($("Hist_etot_"+particle1+particle2))=(0,0,0),rgb($("Hist_E_"+particle2))=(24576,24576,65535)
	ModifyGraph rgb($("Hist_thet_"+particle2))=(24576,24576,65535),rgb($("Hist_phi_"+particle2))=(24576,24576,65535)
	ModifyGraph mirror(right)=0,mirror(left)=0,mirror(bottom)=0
	ModifyGraph lblPos(right)=53,lblPos(bottom1D)=35,lblPos(left)=37,lblPos(bottom)=37
	ModifyGraph lblPos(Y_mid2D)=37,lblPos(X_mid2D)=30,lblPos(Y_top2D)=37,lblPos(X_top2D)=30
	ModifyGraph freePos(bottom1D)={0,right}
	ModifyGraph freePos(Y_mid1D)=0
	ModifyGraph freePos(X_mid1D)={0,Y_mid1D}
	ModifyGraph freePos(Y_top1D)=0
	ModifyGraph freePos(X_top1D)={0,Y_top1D}
	ModifyGraph freePos(Y_mid2D)=0
	ModifyGraph freePos(X_mid2D)={-3.198,Y_mid2D}
	ModifyGraph freePos(Y_top2D)=0
	ModifyGraph freePos(X_top2D)={-0.03094,Y_top2D}
	ModifyGraph axisEnab(right)={0,0.28}
	ModifyGraph axisEnab(bottom1D)={0.55,1}
	ModifyGraph axisEnab(Y_mid1D)={0.36,0.64}
	ModifyGraph axisEnab(X_mid1D)={0.55,1}
	ModifyGraph axisEnab(Y_top1D)={0.72,1}
	ModifyGraph axisEnab(X_top1D)={0.55,1}
	ModifyGraph axisEnab(left)={0,0.28}
	ModifyGraph axisEnab(bottom)={0,0.45}
	ModifyGraph axisEnab(Y_mid2D)={0.36,0.64}
	ModifyGraph axisEnab(X_mid2D)={0,0.45}
	ModifyGraph axisEnab(Y_top2D)={0.72,1}
	ModifyGraph axisEnab(X_top2D)={0,0.45}
	Label bottom1D "E (eV)"
	Label left "E\\B1"
	Label bottom "E\\B2"
	Label Y_mid2D "\\F'Symbol'j\\B2"
	Label X_mid2D "\\F'Symbol'j\\B1"
	Label Y_top2D "\\F'Symbol'q\\B2"
	Label X_top2D "\\F'Symbol'q\\B1"
	SetAxis/A/N=1/E=1 right
	SetAxis/A/N=1/E=1 bottom1D
	SetAxis/A/N=1/E=1 Y_mid1D
	SetAxis/A/N=1/E=1 Y_top1D
	SetAxis/A/E=1 X_top1D
	SetAxis/A/E=1 X_top2D
	TextBox/N=text0/F=0/B=1/A=MC/X=18.86/Y=13.06 "\\Z12\\F'Symbol'\\s(Hist_phi_"+particle1+")j\\B1     \\M\\Z12\\s(Hist_phi_"+particle2+")j\\B2"
	TextBox/N=text0_1/F=0/B=1/A=MC/X=18.59/Y=49.13 "\\Z12\\F'Symbol'\\s(Hist_thet_"+particle1+")q\\B1     \\M\\Z12\\s(Hist_thet_"+particle2+")q\\B2"
	TextBox/N=text0_2/F=0/B=1/A=MC/X=22.57/Y=-25.00 "\\Z12\\s(Hist_e_"+particle1+")E\\B1     \\M\\Z12\\s(Hist_e_"+particle2+")E\\B2     "
	AppendText "\\M\\Z12\\s(Hist_etot_"+particle1+particle2+")E\\Btot"
	ControlBar 50
	string varname=quickinit(particle1,particle2)
	SetVariable E1,pos={8,6},size={90,15},title=particle1+": <E>",value= K3
	SetVariable dE1,pos={31,29},size={67,15},title="dE",value= K4
	SetVariable E2,pos={113,6},size={90,15},title=particle2+": <E>",value= K5
	SetVariable dE2,pos={136,29},size={67,15},title="dE",value= K6
	SetVariable Bin,pos={221,29},size={80,15},title="Bining",value= K7
	SetVariable Weight,pos={221,6},size={150,15},title="Weight",value= $(varname)
	Button $("Refresh_"+particle1+"_"+particle2),pos={313,26},size={60,20},proc=RefreshCorrel,title="Refresh"
EndMacro

function/s quickInit(p1, p2)
string p1, p2
string/g $("weight_"+p1+"_"+p2)
return "weight_"+p1+"_"+p2
end

//------------------------------------------------------------------------------------

Function RefreshMomenta(ctrlName) : ButtonControl
	String ctrlName
	String particle=""
	Variable pos
	pos= findlast(ctrlName,"_")
	if (pos>0)
		particle=ctrlName[pos,strlen(ctrlName)]
		Execute("Histo_Momenta(\""+particle+"\", \"\",-K0,K0,K1,K2)") 
	endif
End

Function RefreshAngleAnergy(ctrlName) : ButtonControl
	String ctrlName
 	String particle=""
	Variable pos
	pos= findlast(ctrlName,"_");particle=ctrlName[pos,strlen(ctrlName)]
	if (pos>0)		
		Execute("Histo_AngleEnergy(\""+particle+"\", \"\",K3,K4,K5)") 
	endif
End

Function RefreshCorrel(ctrlName) : ButtonControl
	String ctrlName
 	String particle1="", particle2=""
	Variable pos1, pos2
	
	pos1= findfirst(ctrlName,"_");pos2= findlast(ctrlName,"_");
	particle1=ctrlName[pos1,pos2-2];particle2=ctrlName[pos2,strlen(ctrlName)]
	
	if ((pos1>0)%&(pos2>0))
		SVAR WeightName=root:$("weight_"+particle1+"_"+particle2)
	     	Execute("Histo_AngleEnergy(\""+particle1+"\",\""+WeightName+"\",K3-K4,K3+K4,K7)")      
	    	Execute("Histo_AngleEnergy(\""+particle2+"\", \""+WeightName+"\",K5-K6,K5+K6,K7)")   
		Execute("Histo_Correlation(\""+particle1+"\",\""+particle2+"\", \""+WeightName+"\",K3,K4,K5,K6,K7)")
	endif
	

End
//------------------------------------------------------------------------------------
function FindLast(InString, theString)
String theString, InString
Variable imax=strlen(InString), i=0,pos=0

Do
	i=strsearch(InString,theString,pos)
	if (i!=-1)
		pos=i+1
	endif
while ((i<imax)%&(i!=-1))

return pos
end

function FindFirst(InString, theString)
String theString, InString
Variable imax=strlen(InString), i=0,pos=0

Do
	i=strsearch(InString,theString,pos)
	if (i!=-1)
		pos=i+1
	endif
while ((i<imax)%&(i!=-1)%&(pos==0))

return pos
end
